#!/bin/sh
# Dynupdate v1.0 from Netwolf Interactive (http://netwolf.citeweb.net)
# --------------
# Author : EISELE Pascal alias Lemmings <peisele@cybercable.tm.fr> 
# Last update : 01/04/2000 
#
# It's an anti-abuse script.
# This script is an addon to ddup (and need it) who watch if address has 
# changed

NET_IFACE=$1
HOST=$2

test -z $1 &&	echo "Dynupdate v1.0 (from Netwolf Interactive)" && \
		echo "Usage : dynupdate NET_IFACE DOMAINE" && \
		echo "Exemple : dynupdate eth1 netwolf.dyndns.org" && \
		exit 0
test -z $2 &&	echo "Dynupdate v1.0 (from Netwolf Interactive)" && \
		echo "Usage : dynupdate [IFACE] [DOMAINE]" && \
		echo "Exemple : dynupdate eth1 netwolf.dyndns.org" && \
		exit 0

# How to find the current ip address of the machine
CURRENT_IP=$(host $HOST |cut -f3)
# How to find new address ip address of machine
NEW_IP=$(ifconfig $NET_IFACE |grep 'inet ad' |cut -d ':' -f2| cut -d ' ' -f1)

test $CURRENT_IP != $NEW_IP && echo $(date) >> /var/log/dyndns && echo $CURRENT_IP '->' $NEW_IP >>/var/log/dyndns && ddup --host $HOST --ip $NEW_IP --wildcard >>/var/log/dyndns 2>&1