#include "Xfct.h"

void init_x(int x, int y, int w, int h, int border, char *name)
{
  dis    = XOpenDisplay  ( NULL );
  screen = DefaultScreen ( dis );
  depth  = DefaultDepth  ( dis , screen );
  width  = DisplayWidth  ( dis , screen );
  height = DisplayHeight ( dis , screen );

  winRoot                  = DefaultRootWindow ( dis );
  winAttr.border_pixel     = BlackPixel ( dis , screen );
  winAttr.background_pixel = BlackPixel ( dis , screen );
  winMask                  = CWBackPixel | CWBorderPixel;
 
  win = XCreateWindow ( dis , winRoot , x , y , w , h , border , depth ,
                        InputOutput , CopyFromParent , winMask , &winAttr );

  XStoreName ( dis , win , name );

  XSelectInput ( dis , win , KeyPressMask );

  winHint.flags                           = PPosition | PMinSize | PMaxSize ;
  winHint.x                               = x;
  winHint.y                               = y;
  winHint.max_width  = winHint.min_width  = w;
  winHint.max_height = winHint.min_height = h;
  XSetWMNormalHints ( dis , win , &winHint );

  XClearWindow ( dis , win );
  XMapRaised ( dis , win );
  XFlush ( dis );

  buffer = ( word * ) calloc ( w*h , 2 );
  xim = XCreateImage ( dis , CopyFromParent , depth , ZPixmap , 0 ,
                       (char *) buffer , w , h , 16 , w*2 );

  gcVal.foreground = 0;
  gcVal.background = 0;
  gcMask           = GCForeground | GCBackground;

  gc = XCreateGC ( dis , win , gcMask , &gcVal );
  printf("Initialising : %dx%dx%d\n", w,h,depth);

} 

void refresh_x(int w, int h)
{
	XPutImage(dis,win,gc,xim,0,0,0,0,w,h);
}

void close_x () 
{

  XFreeGC        ( dis , gc );
  XDestroyImage  ( xim );
  XDestroyWindow ( dis , win );
  XCloseDisplay  ( dis );     

};


